//---------------------------------------------------------------------------

#include <vcl.h>
#include <inifiles.hpp>
#pragma hdrstop

#include "BackupProcess_Form.h"
#include "Message_Form.h"
//---------------------------------------------------------------------------
#pragma package(smart_init)
#pragma link "CGAUGES"
#pragma resource "*.dfm"
TBackupProcessForm *BackupProcessForm;
//---------------------------------------------------------------------------
__fastcall TBackupProcessForm::TBackupProcessForm(TComponent* Owner)
	: TTntForm(Owner)
{
	BreakActivate = false;
}
//---------------------------------------------------------------------------
int __fastcall TBackupProcessForm::Execute(AnsiString backupDir, TBackupContents backupContents)
{
	try
    {
    	BackupDir = backupDir;
    	BackupContents = backupContents;
		this->Show();
        BackupStart();
    }
    catch(...)
    {
    	ShowMessageFA(" ߴܵǾϴ.");
		return mrCancel;
    }
    ShowMessageFA(" ϷǾϴ.");
    this->Close();
	return mrOk;
}
//---------------------------------------------------------------------------
void __fastcall TBackupProcessForm::BackupStart(void)
{
	TCursor oldCursor = this->Cursor;
	this->Cursor = crHourGlass;

	CalculateBackupSpaceLabel->Font->Color = clBlue;
	CalculateBackupSpaceLabel->Caption = " ";
	Repaint();
	CalculateBackupSpace();
	CalculateBackupSpaceLabel->Font->Color = clGreen;
	CalculateBackupSpaceLabel->Caption = "Ϸ";

	ForceDirectories(BackupDir);
	TIniFile *iniFile = new TIniFile(BackupDir + "\\Information.ini");
	if (iniFile)
	{
		iniFile->WriteDate("Information", "Backup Time", Now());
		delete iniFile;
	}

	if (BackupContents.Contains(bcUserInfo))
	{
		BackupUserInfoLabel->Font->Color = clBlue;
		BackupUserInfoLabel->Caption = " ";
		Repaint();
		BackupUserInfo();
		BackupUserInfoLabel->Font->Color = clGreen;
		BackupUserInfoLabel->Caption = "Ϸ";
    }
    else
    {
    	BackupUserInfoLabel->Font->Color = clBlue;
		BackupUserInfoLabel->Caption = "";
    }
    if (BackupContents.Contains(bcSystemInfo))
    {
    	BackupSystemInfoLabel->Font->Color = clBlue;
		BackupSystemInfoLabel->Caption = " ";
		Repaint();
	    BackupSystemInfo();
        BackupSystemInfoLabel->Font->Color = clGreen;
	    BackupSystemInfoLabel->Caption = "Ϸ";
    }
    else
    {
    	BackupSystemInfoLabel->Font->Color = clBlue;
		BackupSystemInfoLabel->Caption = "";
	}
	if (BackupContents.Contains(bcProductInfo))
	{
		BackupProductInfoLabel->Font->Color = clBlue;
		BackupProductInfoLabel->Caption = " ";
		ProductBackupProgressGroupBox->Visible = true;
		Repaint();
		BackupProductInfo(BackupContents.Contains(bcProductImage));
        BackupProductInfoLabel->Font->Color = clGreen;
	    BackupProductInfoLabel->Caption = "Ϸ";
    }
    else
    {
    	BackupProductInfoLabel->Font->Color = clBlue;
		BackupProductInfoLabel->Caption = "";
	}
    if (BackupContents.Contains(bcDefectImage) && !BreakActivate)
    {
    	BackupDefectImageLabel->Font->Color = clBlue;
		BackupDefectImageLabel->Caption = " ";
		Repaint();
	    BackupDefectImage();
        BackupDefectImageLabel->Font->Color = clGreen;
	    BackupDefectImageLabel->Caption = "Ϸ";
    }
    else
    {
    	BackupDefectImageLabel->Font->Color = clBlue;
		BackupDefectImageLabel->Caption = "";
	}

	this->Cursor = oldCursor;
}
//---------------------------------------------------------------------------
void __fastcall TBackupProcessForm::CalculateBackupSpace(void)
{

}
//---------------------------------------------------------------------------
bool __fastcall TBackupProcessForm::BackupUserInfo(void)
{
	AnsiString userInfoDir = BackupDir + "\\UserInfo";
	ForceDirectories(userInfoDir);
    AnsiString sourceFileName = ProgramPath.Env + "\\user.ini";
    AnsiString destFileName = userInfoDir + "\\user.ini";
    CopyFile(sourceFileName.c_str(), destFileName.c_str(), FALSE);
    TIniFile *iniFile = new TIniFile(BackupDir + "\\Information.ini");
    if (iniFile)
    {
        iniFile->WriteBool("Information", "Backup User Info Data", true);
        delete iniFile;
    }
	return true;
}
//---------------------------------------------------------------------------
bool __fastcall TBackupProcessForm::BackupSystemInfo(void)
{
	AnsiString fileList[10] = {"VersionInfo.ini", "UserMachineInfor.ini", "Ranger3DCameraInfo.ini",
		"MachineInfor.ini", "SystemInfor.ini", "ShutterSpeedInfor.ini", "ColorCode.ini", "Download.ini",
		"DSMInfor.ini", "SystemSetup.ini"};
	AnsiString systemInfoDir = BackupDir + "\\SystemInfo";
	ForceDirectories(systemInfoDir);
	for (int fileIndex = 0; fileIndex < 10; fileIndex++)
	{
		AnsiString sourceFileName = ProgramPath.Env + "\\" + fileList[fileIndex];
	    AnsiString destFileName = systemInfoDir + "\\" + fileList[fileIndex];
	    CopyFile(sourceFileName.c_str(), destFileName.c_str(), FALSE);
    }
    TIniFile *iniFile = new TIniFile(BackupDir + "\\Information.ini");
    if (iniFile)
    {
        iniFile->WriteBool("Information", "Backup System Info Data", true);
        delete iniFile;
    }
    return true;
}
//---------------------------------------------------------------------------
bool __fastcall TBackupProcessForm::BackupProductInfo(bool bIncludeProductImage)
{
	TSearchRec sr;
    int iAttributes = faDirectory;
	AnsiString destDirRoot = BackupDir + "\\Product";
    AnsiString productDir = ProgramPath.Product;
    ForceDirectories(destDirRoot);

//    AnsiString srcFile = productDir + "\\*.*";
//    AnsiString destFile = destDirRoot + "\\*.*";
//    BOOL bCancel;
//    CopyFileEx(srcFile.c_str(), destFile.c_str(), NULL, NULL, &bCancel, 0);

	int productCount = 0;
	if (FindFirst(productDir + "\\*.*", iAttributes, sr) == 0)
	{
		do
		{
			if ((sr.Attr & iAttributes) == sr.Attr && sr.Name != "." && sr.Name != "..")
			{
				productCount++;
			}
		} while (FindNext(sr) == 0);
		FindClose(sr);
	}

	int currentProductCount = 0;

	if (FindFirst(productDir + "\\*.*", iAttributes, sr) == 0)
	{
		do
		{
			if ((sr.Attr & iAttributes) == sr.Attr && sr.Name != "." && sr.Name != "..")
			{
				ProductNameLabel->Caption = sr.Name;
				if (productCount)
				{
					CGauge1->Progress = currentProductCount * 100 / productCount;
				}
				if (bIncludeProductImage)
				{
					CopyDir(destDirRoot + "\\" + sr.Name, productDir + "\\" + sr.Name);
				}
				else
				{
					CopyDirExcludeImage(destDirRoot + "\\" + sr.Name, productDir + "\\" + sr.Name);
				}
				currentProductCount++;
			}
		} while (FindNext(sr) == 0);
		FindClose(sr);
	}
	if (!BreakActivate)
	{
		TIniFile *iniFile = new TIniFile(BackupDir + "\\Information.ini");
		if (iniFile)
		{
			iniFile->WriteBool("Information", "Backup Product Info Data", true);
			delete iniFile;
		}
	}
    return true;
}
//---------------------------------------------------------------------------
bool __fastcall TBackupProcessForm::BackupDefectImage(void)
{
    TIniFile *iniFile = new TIniFile(BackupDir + "\\Information.ini");
    if (iniFile)
    {
        iniFile->WriteBool("Information", "Backup Defect Image Data", true);
        delete iniFile;
    }
    return true;
}
//---------------------------------------------------------------------------
void __fastcall TBackupProcessForm::CopyDir(AnsiString destDir, AnsiString srcDir)
{
	TSearchRec sr;
	int iAttributes = faAnyFile;
	CreateDir(destDir);
	if (FindFirst(srcDir + "\\*.*", iAttributes, sr) == 0)
	{
		do
		{
			if (sr.Name == "." || sr.Name == "..") continue;
			if ((sr.Attr & faDirectory))
			{
				CopyDir(destDir + "\\" + sr.Name, srcDir + "\\" + sr.Name);
			}
			else
			{
				AnsiString sourceFileName = srcDir + "\\" + sr.Name;
				AnsiString destFileName = destDir + "\\" + sr.Name;
				CopyFile(sourceFileName.c_str(), destFileName.c_str(), FALSE);
			}
			Application->ProcessMessages();
			if (BreakActivate) break;
		} while (FindNext(sr) == 0);
		FindClose(sr);
	}
}
//---------------------------------------------------------------------------
void __fastcall TBackupProcessForm::CopyDirExcludeImage(AnsiString destDir, AnsiString srcDir)
{
	TSearchRec sr;
	int iAttributes = faAnyFile;
	CreateDir(destDir);
	if (FindFirst(srcDir + "\\*.*", iAttributes, sr) == 0)
	{
		do
		{
			if (sr.Name == "." || sr.Name == "..") continue;
			if ((sr.Attr & faDirectory))
			{
				if (sr.Name == "Image")
				{
					CreateDir(destDir + "\\Image");
					CopyOneImage(destDir + "\\Image", srcDir + "\\Image");
				}
				else
				{
					CopyDir(destDir + "\\" + sr.Name, srcDir + "\\" + sr.Name);
				}
			}
			else
			{
				AnsiString sourceFileName = srcDir + "\\" + sr.Name;
				AnsiString destFileName = destDir + "\\" + sr.Name;
				CopyFile(sourceFileName.c_str(), destFileName.c_str(), FALSE);
			}
			Application->ProcessMessages();
			if (BreakActivate) break;
		} while (FindNext(sr) == 0);
		FindClose(sr);
	}
}
//---------------------------------------------------------------------------
void __fastcall TBackupProcessForm::CopyOneImage(AnsiString destDir, AnsiString srcDir)
{
	AnsiString sourceFileName, destFileName;
	for (int globalCameraIndex = 0; globalCameraIndex < SYSTEM_TOTAL_CAMERA_COUNT; globalCameraIndex++)
	{
		sourceFileName = srcDir + "\\Image1_" + IntToStr(globalCameraIndex + 1) + ".bmp";
		destFileName = destDir + "\\Image1_" + IntToStr(globalCameraIndex + 1) + ".bmp";
		CopyFile(sourceFileName.c_str(), destFileName.c_str(), FALSE);
	}
	sourceFileName = srcDir + "\\Image1_1_O.bmp";
	destFileName = destDir + "\\Image1_1_O.bmp";
	CopyFile(sourceFileName.c_str(), destFileName.c_str(), FALSE);
	sourceFileName = srcDir + "\\Image1_6_O.bmp";
	destFileName = destDir + "\\Image1_6_O.bmp";
	CopyFile(sourceFileName.c_str(), destFileName.c_str(), FALSE);
}
//---------------------------------------------------------------------------
void __fastcall TBackupProcessForm::BreakButtonClick(TObject *Sender)
{
	BreakActivate = true;
}
//---------------------------------------------------------------------------

